# Nanolib

This is the C++ Version of the Nanolib.

## Windows
# Example
1. Open Visual Studio, create a new command line project.
2. Open the settings of the project
   1. In the compiler settings
      1. add the "include" path to the "Additional Include Paths"
      2. and set the "C++ Language Standard" (under "Language") to "ISO C++17 (/std:c++17)"
   2. In the linker settings
     1. add the path of the *.dll to "Additional Library Directories"
	 2. add the file "nanolib.lib" to the "Additional Dependencies"
3. Copy the following code to the main file:
```C++
#include "accessor_factory.hpp"
#include <iostream>

int main(){
  nlc::NanoLibAccessor *accessor = getNanoLibAccessor();
  nlc::ResultBusHwIds result = accessor->listAvailableBusHardware();

  if(result.hasError()) { std::cout << result.getError() << std::endl; }
  else{ std::cout << "Success" << std::endl; }

  delete accessor;
  return 0;
}
```
4. Compile everything
5. Before running the executable, copy the files "nanolib.dll", nanolibm_modbus.dll and "nanolibm_canopen.dll" to the same folder of the executable.
6. Run the executable, it will print out the found hardware specifiers and the error register.

## Linux

1. Install the Library
```bash
  sudo make install
```
2. Build the example
```bash
  make
```
 Note: The following command from the make script will require sudo privileges:
>sudo setcap cap_net_raw,cap_net_admin=eip $(OUT_PATH)example

It is necessary to allow Modbus TCP bus scanning.
see: https://linux.die.net/man/7/capabilities

4. Execute the example
```bash
  ./bin/example
```

5. Uninstall the Library if needed
```bash
  sudo make uninstall
```
